<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ContractRescission extends Model 
{

    protected $table = 'contract_rescissions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('contract_id', 'employee_category', 'syndical_code', 'syndicate_cnpj', 'syndicate_name', 'was_warned', 'warning_date', 'rescision_date', 'rescision_code', 'last_salary', 'alimone', 'alimone_on_fgts');
    protected $visible = array('contract_id', 'employee_category', 'syndical_code', 'syndicate_cnpj', 'syndicate_name', 'was_warned', 'warning_date', 'rescision_date', 'rescision_code', 'last_salary', 'alimone', 'alimone_on_fgts');

    public function contract()
    {
        return $this->belongsTo('EmployeeContract', 'contract_id', 'id');
    }

}